/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.offline;

import com.google.common.collect.ImmutableSet;
import dev.ftb.extendedexchange.offline.OfflineKnowledgeManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.impl.capability.KnowledgeImpl;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

class OfflineKnowledge
implements IKnowledgeProvider {
    private final UUID id;
    private final boolean fullKnowledge;
    private final Set<ItemInfo> knowledge;
    private final ItemStackHandler inputLocks = new ItemStackHandler(9);
    private BigInteger emc;

    private OfflineKnowledge(UUID id, IKnowledgeProvider toCopy) {
        this.id = id;
        this.fullKnowledge = toCopy.hasFullKnowledge();
        this.emc = toCopy.getEmc();
        this.knowledge = ImmutableSet.copyOf((Collection)toCopy.getKnowledge());
        for (int i = 0; i < toCopy.getInputAndLocks().getSlots(); ++i) {
            this.inputLocks.setStackInSlot(i, toCopy.getInputAndLocks().getStackInSlot(i).m_41777_());
        }
    }

    static OfflineKnowledge forPlayerId(UUID id) {
        File playerFile;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return null;
        }
        File playerData = server.m_129843_(LevelResource.f_78176_).toFile();
        if (playerData.exists() && (playerFile = new File(playerData, id.toString() + ".dat")).exists() && playerFile.isFile()) {
            try {
                FileInputStream in = new FileInputStream(playerFile);
                try {
                    CompoundTag playerDat = NbtIo.m_128939_((InputStream)in);
                    CompoundTag data = playerDat.m_128469_("ForgeCaps").m_128469_(KnowledgeImpl.Provider.NAME.toString());
                    IKnowledgeProvider provider = KnowledgeImpl.getDefault();
                    provider.deserializeNBT((Tag)data);
                    return new OfflineKnowledge(id, provider);
                }
                catch (IOException e) {
                    try {
                        in.close();
                    }
                    catch (Throwable e2) {
                        e.addSuppressed(e2);
                    }
                    return null;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean hasFullKnowledge() {
        return this.fullKnowledge;
    }

    public void setFullKnowledge(boolean fullKnowledge) {
    }

    public void clearKnowledge() {
    }

    public boolean hasKnowledge(@NotNull ItemInfo itemInfo) {
        return this.knowledge.contains(itemInfo);
    }

    public boolean addKnowledge(@NotNull ItemInfo itemInfo) {
        return false;
    }

    public boolean removeKnowledge(@NotNull ItemInfo itemInfo) {
        return false;
    }

    @NotNull
    public Set<ItemInfo> getKnowledge() {
        return this.knowledge;
    }

    @NotNull
    public IItemHandler getInputAndLocks() {
        return this.inputLocks;
    }

    public BigInteger getEmc() {
        return this.emc;
    }

    public void setEmc(BigInteger emc) {
        this.emc = emc;
        OfflineKnowledgeManager.getInstance().onEmcChanged();
    }

    public void sync(@NotNull ServerPlayer serverPlayer) {
    }

    public void syncEmc(@NotNull ServerPlayer serverPlayer) {
    }

    public void syncKnowledgeChange(@NotNull ServerPlayer serverPlayer, ItemInfo itemInfo, boolean b) {
    }

    public void syncInputAndLocks(@NotNull ServerPlayer serverPlayer, List<Integer> list, IKnowledgeProvider.TargetUpdateType targetUpdateType) {
    }

    public void receiveInputsAndLocks(Map<Integer, ItemStack> map) {
    }

    public CompoundTag serializeNBT() {
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag arg) {
    }
}

